import { Film, Mail, Phone, MapPin, Instagram, Youtube, Twitter } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer-film">
      <div className="container">
        <div className="footer-content-film">
          <div className="footer-section-film">
            <div className="footer-logo-film">
              <div className="footer-logo-icon">
                <Film size={24} strokeWidth={2.5} />
              </div>
              <h2 className="footer-logo-text-film">FilmCut</h2>
            </div>
            <p className="footer-description-film">
              Профессиональные курсы видеомонтажа для начинающих и продвинутых. 
              Изучите все тонкости работы с видео от опытных преподавателей.
            </p>
            <div className="footer-social-film">
              <a href="#" className="social-link-film">
                <Instagram size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link-film">
                <Youtube size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link-film">
                <Twitter size={20} strokeWidth={2} />
              </a>
            </div>
          </div>
          <div className="footer-section-film">
            <h3 className="footer-title-film">Навигация</h3>
            <ul className="footer-links-film">
              <li><a href="/">Мои проекты</a></li>
              <li><a href="/enroll">Записаться</a></li>
              <li><a href="#">Курсы</a></li>
              <li><a href="#">О нас</a></li>
            </ul>
          </div>
          <div className="footer-section-film">
            <h3 className="footer-title-film">Контакты</h3>
            <ul className="footer-links-film">
              <li>
                <Phone size={16} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} strokeWidth={2} />
                <a href="mailto:info@filmcut.ru">info@filmcut.ru</a>
              </li>
              <li>
                <MapPin size={16} strokeWidth={2} />
                <span>Москва, ул. Кинематографическая, 15</span>
              </li>
            </ul>
          </div>
          <div className="footer-section-film">
            <h3 className="footer-title-film">Режим работы</h3>
            <ul className="footer-links-film">
              <li><span>Пн-Пт: 10:00 - 20:00</span></li>
              <li><span>Сб-Вс: 12:00 - 18:00</span></li>
              <li><span>Онлайн: 24/7</span></li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom-film">
          <p>&copy; 2025 FilmCut. Ваш путь в видеомонтаже начинается здесь.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

